/*

	CREAZIONE TABELLA CGI6_MODIVADETT RIGHE DETTAGLIO MODELLO IVA

*/
--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[CGI6_MODIVADETT]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
	BEGIN
			CREATE TABLE CGI6_MODIVADETT (
						 CGI6_ID			BIGINT				IDENTITY,
						 CGI6_ID_CGI5		BIGINT				NOT NULL,
					     CGI6_DITTA_CG18	DECIMAL(5)			NOT	NULL,
						 CGI6_CODATTIVITA	DECIMAL(5)			NOT	NULL,
						 CGI6_ANNO			SMALLINT			NOT NULL,
						 CGI6_MODULO		SMALLINT			NULL,
						 CGI6_QUADRO		SMALLINT			NULL,
						 CGI6_FLGMOVIVA		TINYINT				NOT NULL	DEFAULT 0,
						 CGI6_SORT			NVARCHAR(5)			NULL,
						 CGI6_RIGA			INT					NULL,
						 CGI6_DESRIGA		NVARCHAR(100)		NULL,
						 CGI6_TIPOCAR		TINYINT				NOT NULL	DEFAULT 0,
						 CGI6_STRINGASQL	NVARCHAR(MAX)		NULL,
						 CGI5_ROWVERSION	TIMESTAMP			NOT NULL
			)
			
			CREATE INDEX FK_CGI6_CGI5 ON CGI6_MODIVADETT
			(
				CGI6_ID_CGI5            ASC
			)

			CREATE INDEX FK_CGI6_CG18 ON CGI6_MODIVADETT
			(
				CGI6_DITTA_CG18             ASC
			)

			ALTER TABLE CGI6_MODIVADETT
                  ADD CONSTRAINT PK_CGI6
				      PRIMARY KEY (CGI6_ID ASC)

			ALTER TABLE CGI6_MODIVADETT
                  ADD CONSTRAINT FK_CGI6_CGI5
                      FOREIGN KEY (CGI6_ID_CGI5)
                              REFERENCES CGI5_MODIVA (CGI5_ID)

			ALTER TABLE CGI6_MODIVADETT
                  ADD CONSTRAINT FK_CGI6_CG18
                      FOREIGN KEY (CGI6_DITTA_CG18)
                              REFERENCES CG18_ANADITTABASE (CG18_DITTA)

		PRINT 'Tabella CGI6_MODIVADETT: creazione effettuata con successo.'
	END
ELSE
	PRINT 'Tabella CGI6_MODIVADETT esistente: creazione non effettuata.'
GO

--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
